﻿using System;
using VA.TMP.Integration.VIMT.HealthShare.Mappers;
using VA.TMP.Integration.VIMT.HealthShare.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.HealthShare.PipelineSteps.MakeCancel
{
    /// <summary>
    /// Map Appointment to CRM etities step.
    /// </summary>
    public class MapAppointmentStep : FilterBase<MakeCancelStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(MakeCancelStateObject state)
        {
            try
            {
                state.Appointment = new MakeCancelMapper(state.RequestMessage, state.OrganizationServiceProxy).Map();
            }
            catch (Exception ex)
            {
                throw new Exception(string.Format("HealthShare Make Cancel MapAppointmentStep Pipeline Error: {0}", ex.Message), ex.InnerException);
            }
        }
    }
}